import { Shield, Star, MapPin, CreditCard } from "lucide-react";

const highlights = [
  {
    icon: Star,
    title: "Luxury Rooms",
    description: "Elegantly designed spaces with premium amenities for your utmost comfort.",
  },
  {
    icon: Shield,
    title: "Exceptional Service",
    description: "24/7 dedicated staff ensuring your every need is met with care.",
  },
  {
    icon: MapPin,
    title: "Prime Location",
    description: "Situated in the heart of the city with easy access to attractions.",
  },
  {
    icon: CreditCard,
    title: "Secure Booking",
    description: "Safe and easy online reservations with instant confirmation.",
  },
];

export function HighlightsSection() {
  return (
    <section className="py-20 bg-muted">
      <div className="container mx-auto px-4 lg:px-8">
        {/* Section Header */}
        <div className="text-center mb-16">
          <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
            Why Choose Us
          </span>
          <h2 className="text-3xl md:text-4xl font-serif font-bold text-foreground mt-3 mb-4">
            The Hotili Experience
          </h2>
          <div className="gold-divider" />
        </div>

        {/* Highlights Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {highlights.map((item, index) => (
            <div
              key={index}
              className="group bg-card rounded-xl p-8 text-center shadow-card hover:shadow-elevated transition-all duration-500 hover:-translate-y-2 gold-border"
            >
              <div className="w-16 h-16 mx-auto mb-6 rounded-full bg-primary flex items-center justify-center group-hover:bg-gold transition-colors duration-500">
                <item.icon className="w-7 h-7 text-gold group-hover:text-charcoal transition-colors duration-500" />
              </div>
              <h3 className="text-xl font-serif font-semibold text-foreground mb-3">
                {item.title}
              </h3>
              <p className="text-muted-foreground text-sm leading-relaxed">
                {item.description}
              </p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
