import { Button } from "@/components/ui/button";
import heroImage from "@/assets/hero-hotel.jpg";

export function HeroSection() {
  return (
    <section className="relative min-h-screen flex items-center justify-center overflow-hidden">
      {/* Background Image */}
      <div className="absolute inset-0">
        <img
          src={heroImage}
          alt="Hotili Luxury Hotel Lobby"
          className="w-full h-full object-cover"
        />
        <div className="absolute inset-0 bg-gradient-hero" />
      </div>

      {/* Content */}
      <div className="relative z-10 container mx-auto px-4 lg:px-8 text-center">
        <div className="max-w-4xl mx-auto animate-fade-in-up">
          {/* Decorative Element */}
          <div className="flex items-center justify-center gap-4 mb-6">
            <div className="h-px w-12 bg-gold/60" />
            <span className="text-gold text-sm tracking-[0.3em] uppercase font-medium">
              Welcome to Luxury
            </span>
            <div className="h-px w-12 bg-gold/60" />
          </div>

          {/* Main Headline */}
          <h1 className="text-4xl md:text-5xl lg:text-7xl font-serif font-bold text-cream mb-6 leading-tight">
            Experience Comfort &{" "}
            <span className="text-gradient-gold">Elegance</span> at Hotili
          </h1>

          {/* Subheadline */}
          <p className="text-lg md:text-xl text-cream/90 mb-10 max-w-2xl mx-auto leading-relaxed">
            Where modern luxury meets warm hospitality. Discover a sanctuary of refined 
            comfort in the heart of the city.
          </p>

          {/* CTA Buttons */}
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button variant="hero" size="xl">
              Book Your Stay
            </Button>
            <Button variant="heroOutline" size="xl">
              Explore Rooms
            </Button>
          </div>
        </div>
      </div>

      {/* Scroll Indicator */}
      <div className="absolute bottom-8 left-1/2 -translate-x-1/2 animate-bounce">
        <div className="w-6 h-10 border-2 border-gold/60 rounded-full flex items-start justify-center p-1">
          <div className="w-1.5 h-3 bg-gold rounded-full animate-pulse" />
        </div>
      </div>
    </section>
  );
}
