<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('guest_id')->constrained()->onDelete('restrict');
            $table->foreignId('room_type_id')->constrained()->onDelete('restrict');
            $table->string('booking_reference')->unique();
            $table->date('checkin_date');
            $table->date('checkout_date');
            $table->enum('status', [
                'pending',
                'confirmed',
                'checked_in',
                'checked_out',
                'cancelled',
                'no_show'
            ])->default('pending');
            $table->integer('number_of_guests')->default(1);
            $table->text('special_requests')->nullable();
            $table->decimal('total_price', 10, 2)->nullable();
            $table->timestamps();

            // Indexes for common queries
            $table->index('booking_reference');
            $table->index('status');
            $table->index(['checkin_date', 'checkout_date']);
            $table->index('guest_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
