<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();
            $table->foreignId('room_type_id')->constrained()->onDelete('restrict');
            $table->string('room_number')->unique(); // e.g., 101, 102, 201
            $table->integer('floor')->nullable();
            $table->enum('status', [
                'available',
                'reserved',
                'occupied',
                'cleaning',
                'maintenance'
            ])->default('available');
            $table->timestamps();

            // Index for quick status lookups
            $table->index('status');
            $table->index('room_type_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rooms');
    }
};
