<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Guest extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'phone',
        'first_name',
        'last_name',
        'email',
        'id_number',
    ];

    /**
     * Get all bookings for this guest.
     */
    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }
}
